/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import java.util.Comparator;
import java.util.Enumeration;
import java.util.TreeSet;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.InstanceComparator;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.UnsupervisedFilter;

public class RemoveDuplicated
extends SimpleBatchFilter
implements UnsupervisedFilter,
OptionHandler {
    private static final long serialVersionUID = -625792014317428164L;
    protected boolean m_Invert = false;
    protected boolean m_IfClass = true;

    public boolean getInvert() {
        return this.m_Invert;
    }

    public void setInvert(boolean invert) {
        this.m_Invert = invert;
    }

    public String invertTipText() {
        return "Specifies whether unique or duplicated instances will be returned. False will return unique instances, true will return duplicated instances.";
    }

    public boolean getIfClass() {
        return this.m_IfClass;
    }

    public void setIfClass(boolean ifClass) {
        this.m_IfClass = ifClass;
    }

    public String ifClassTipText() {
        return "Specifies whether the attribute class will be used in the comparison. False will not use it, true will use it.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.disable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        newVector.addElement(new Option("\tSpecifies whether unique or duplicated instances will be returned.\n", "I", 0, "-I"));
        newVector.addElement(new Option("\tSpecifies whether the attribute class will be used in the comparison.\n", "C", 0, "-C"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String invertString = Utils.getOption((char)'I', (String[])options);
        if (invertString.length() != 0) {
            this.setInvert(true);
        } else {
            this.setInvert(false);
        }
        String ifClassString = Utils.getOption((char)'C', (String[])options);
        if (ifClassString.length() != 0) {
            this.setIfClass(true);
        } else {
            this.setIfClass(false);
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] options = new String[2];
        int current = 0;
        if (this.getInvert()) {
            options[current++] = "-I";
        }
        if (this.getIfClass()) {
            options[current++] = "-C";
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String globalInfo() {
        return "A filter that removes the duplicated instances of a dataset";
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        Instances result = new Instances(inputFormat, 0);
        return result;
    }

    protected Instances process(Instances instances) throws Exception {
        Instances result = new Instances(this.determineOutputFormat(instances), 0);
        Instances duplicated = new Instances(this.determineOutputFormat(instances), 0);
        InstanceComparator comp = new InstanceComparator(this.m_IfClass);
        TreeSet<Instance> set = new TreeSet<Instance>((Comparator<Instance>)comp);
        int uniques = 0;
        int i = 0;
        while (i < instances.numInstances()) {
            set.add(instances.instance(i));
            if (uniques + 1 == set.size()) {
                result.add(instances.instance(i));
                ++uniques;
            } else {
                duplicated.add(instances.instance(i));
            }
            ++i;
        }
        String exceptionMsg = new String("0 instances will be returned. Additional information:\n\t" + uniques + ": unique instances." + "\n\t" + duplicated.size() + ": duplicated instances." + "\n\tifClass: " + this.m_IfClass + "\n\t" + this.getInputFormat().classAttribute().toString());
        if (this.m_Invert) {
            if (duplicated.size() == 0) {
                throw new Exception(exceptionMsg);
            }
            return duplicated;
        }
        if (result.size() == 0) {
            throw new Exception(exceptionMsg);
        }
        return result;
    }

    public static void main(String[] argv) {
        RemoveDuplicated.runFilter((Filter)new RemoveDuplicated(), (String[])argv);
    }
}

