/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.instance;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SupervisedFilter;

public class RUS
extends Filter
implements SupervisedFilter,
OptionHandler,
TechnicalInformationHandler {
    private static final long serialVersionUID = -1440151492573627546L;
    protected double m_Percentage = 75.0;

    public String globalInfo() {
        return "A filter that eliminates some random majority instances until the total amount of majority instances reaches the percentage given. For more information, see\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "G.E.A.P.A. Batista, R.C. Prati, M.C. Monard");
        result.setValue(TechnicalInformation.Field.TITLE, "A study of the behavior of several methods for balancing machine learning training data");
        result.setValue(TechnicalInformation.Field.JOURNAL, "SIGKDD Explorations");
        result.setValue(TechnicalInformation.Field.YEAR, "2004");
        result.setValue(TechnicalInformation.Field.VOLUME, "6");
        result.setValue(TechnicalInformation.Field.PAGES, "Issue 1, 20-29");
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 1 $");
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.BINARY_CLASS);
        return result;
    }

    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        newVector.addElement(new Option("\tSpecifies percentage of the proportion of majority class.\n\t(default 75.0)\n", "P", 1, "-P <percentage>"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String percentageStr = Utils.getOption((char)'P', (String[])options);
        if (percentageStr.length() != 0) {
            this.setPercentage(new Double(percentageStr));
        } else {
            this.setPercentage(75.0);
        }
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-P");
        result.add("" + this.getPercentage());
        return result.toArray(new String[result.size()]);
    }

    public String percentageTipText() {
        return "Specifies the proportion of majority class desired.";
    }

    public void setPercentage(double value) {
        if (value < 1.0 || value > 99.0) {
            throw new IllegalArgumentException("Percentage must be between 1 and 99.");
        }
        this.m_Percentage = value;
    }

    public double getPercentage() {
        return this.m_Percentage;
    }

    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        super.setOutputFormat(instanceInfo);
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.m_FirstBatchDone) {
            this.push(instance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    public boolean batchFinished() throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (!this.m_FirstBatchDone) {
            this.doRUS();
        }
        this.flushInput();
        this.m_NewBatch = true;
        this.m_FirstBatchDone = true;
        return this.numPendingOutput() != 0;
    }

    protected void doRUS() throws Exception {
        Instances instances = new Instances(this.getInputFormat(), 0, this.getInputFormat().size());
        int minIndex = 0;
        int maxIndex = 0;
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        int[] classCounts = this.getInputFormat().attributeStats((int)this.getInputFormat().classIndex()).nominalCounts;
        int i = 0;
        while (i < classCounts.length) {
            if (classCounts[i] != 0 && classCounts[i] < min) {
                min = classCounts[i];
                minIndex = i;
            }
            if (classCounts[i] != 0 && classCounts[i] > max) {
                max = classCounts[i];
                maxIndex = i;
            }
            ++i;
        }
        ArrayList<Integer> majority = new ArrayList<Integer>();
        int i2 = 0;
        while (i2 < instances.size()) {
            if ((int)instances.get(i2).classValue() == maxIndex) {
                majority.add(i2);
            }
            ++i2;
        }
        int finalMajorityInstances = (int)(this.m_Percentage * (double)classCounts[minIndex] / (100.0 - this.m_Percentage));
        int majorityInstancesToDelete = classCounts[maxIndex] - finalMajorityInstances;
        Random r = new Random();
        int i3 = 0;
        while (i3 < majorityInstancesToDelete) {
            majority.remove(r.nextInt(majority.size()));
            ++i3;
        }
        i3 = 0;
        while (i3 < instances.size()) {
            if ((int)instances.get(i3).classValue() == minIndex || (int)instances.get(i3).classValue() == maxIndex && majority.contains(i3)) {
                this.push((Instance)instances.get(i3).copy());
            }
            ++i3;
        }
    }

    public static void main(String[] args) {
        RUS.runFilter((Filter)new RUS(), (String[])args);
    }
}

