/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.UnassignedDatasetException;
import weka.core.Utils;
import weka.core.neighboursearch.NearestNeighbourSearch;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;

public class ENN
extends Filter
implements UnsupervisedFilter,
OptionHandler {
    private static final long serialVersionUID = 11L;
    private int m_RandomSeed = 1;
    private int m_kNeighborsFactor = 5;

    public String globalInfo() {
        return "Removes examples for the imbalanced classes using Wilson Editing algorithm";
    }

    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        newVector.addElement(new Option("\tSpecify the factor of nearest neighbors for\n\teach class sample (default 5)", "K", 3, "-K <num>"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String sOption = Utils.getOption((char)'K', (String[])options);
        if (sOption.length() != 0) {
            this.setKNeighborsFactor(Integer.parseInt(sOption));
        } else {
            this.setKNeighborsFactor(5);
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        Vector<String> vOptions = new Vector<String>();
        vOptions.add("-K");
        vOptions.add("" + this.getKNeighborsFactor());
        return vOptions.toArray(new String[vOptions.size()]);
    }

    public String randomSeedTipText() {
        return "The seed used for random sampling.";
    }

    public int getRandomSeed() {
        return this.m_RandomSeed;
    }

    public void setRandomSeed(int newSeed) {
        this.m_RandomSeed = newSeed;
    }

    public String KNeighborsFactorTipText() {
        return "The factor of nearest neighbors for each minority class sample.";
    }

    public int getKNeighborsFactor() {
        return this.m_kNeighborsFactor;
    }

    public void setKNeighborsFactor(int nNeighbors) {
        if (nNeighbors <= 0) {
            throw new IllegalArgumentException("k factor must be at least 1");
        }
        this.m_kNeighborsFactor = nNeighbors;
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        if (!instanceInfo.classAttribute().isNominal() || instanceInfo.classIndex() < 0) {
            throw new IllegalArgumentException("This filter requires nominal class");
        }
        this.m_FirstBatchDone = false;
        super.setInputFormat(instanceInfo);
        this.setOutputFormat(instanceInfo);
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.m_FirstBatchDone) {
            this.push(instance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public boolean batchFinished() {
        block6: {
            if (this.getInputFormat() == null) {
                throw new IllegalStateException("No input instance format defined");
            }
            if (!this.isFirstBatchDone()) {
                try {
                    this.applyWilsonEditing();
                    break block6;
                }
                catch (IllegalArgumentException iArgException) {
                    throw iArgException;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    nInstance = 0;
                    ** while (nInstance < this.getInputFormat().numInstances())
                }
lbl-1000:
                // 1 sources

                {
                    this.push(this.getInputFormat().instance(nInstance));
                    ++nInstance;
                    continue;
                }
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        this.m_FirstBatchDone = true;
        return this.numPendingOutput() != 0;
    }

    /*
     * Unable to fully structure code
     */
    private void applyWilsonEditing() throws Exception {
        sourceInstances = this.getInputFormat();
        numSourceInstances = sourceInstances.numInstances();
        nClassIndex = sourceInstances.classIndex();
        stats = sourceInstances.attributeStats(nClassIndex);
        nClasses = stats.distinctCount;
        nNerarestNeighborsClasses = new int[nClasses];
        nClassValue = 0.0;
        currI = null;
        nIdx = 0;
        markedInstances = new int[numSourceInstances];
        nNumMarkedInstances = 0;
        kNNInstances = null;
        linNSearch = new LinearNNSearchENN(sourceInstances);
        currInstanceIndex = 0;
        while (currInstanceIndex < numSourceInstances) {
            nIdx = 0;
            while (nIdx < nClasses) {
                nNerarestNeighborsClasses[nIdx] = 0;
                ++nIdx;
            }
            currI = sourceInstances.instance(currInstanceIndex);
            linNSearch.kNearestNeighbours(currI, this.m_kNeighborsFactor);
            kNNInstances = linNSearch.getNearestInstances();
            nIdx = 0;
            while (nIdx < this.m_kNeighborsFactor) {
                v0 = classValue = (int)kNNInstances[nIdx].classValue();
                nNerarestNeighborsClasses[v0] = nNerarestNeighborsClasses[v0] + 1;
                ++nIdx;
            }
            classValue = (int)currI.classValue();
            nAgreeNeighbors = nNerarestNeighborsClasses[classValue];
            bRemove = false;
            nIdx = 0;
            while (nIdx < nNerarestNeighborsClasses.length && !bRemove) {
                if (nIdx != classValue) {
                    bRemove = nNerarestNeighborsClasses[nIdx] > nAgreeNeighbors;
                }
                ++nIdx;
            }
            if (bRemove) {
                markedInstances[nNumMarkedInstances] = currInstanceIndex;
                ++nNumMarkedInstances;
            }
            ++currInstanceIndex;
        }
        Arrays.sort(markedInstances, 0, markedInstances.length);
        nIdx = 0;
        nMarkedInstanceIdx = 0;
        ** GOTO lbl55
        {
            this.push(sourceInstances.instance(nIdx));
            ++nIdx;
            do {
                if (nIdx < markedInstances[nMarkedInstanceIdx]) continue block4;
                ++nIdx;
                ++nMarkedInstanceIdx;
lbl55:
                // 2 sources

            } while (nMarkedInstanceIdx < nNumMarkedInstances);
        }
        while (nIdx < numSourceInstances) {
            this.push(sourceInstances.instance(nIdx));
            ++nIdx;
        }
    }

    public static void runFilter(Filter filter, String[] options) {
        try {
            if (Utils.getFlag((char)'b', (String[])options)) {
                Filter.batchFilterFile((Filter)filter, (String[])options);
            } else {
                Filter.filterFile((Filter)filter, (String[])options);
            }
        }
        catch (Exception ex) {
            if (ex.toString().indexOf("Help requested") == -1 && ex.toString().indexOf("Filter options") == -1) {
                ex.printStackTrace();
            }
            System.err.println(ex.getMessage());
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                throw new Exception("First argument must be the class name of a Filter");
            }
            String fname = args[0];
            Filter f = (Filter)Class.forName(fname).newInstance();
            args[0] = "";
            ENN.runFilter(f, args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    public class LinearNNSearchENN
    extends NearestNeighbourSearch {
        private static final long serialVersionUID = 1915484723703917241L;
        protected double[] m_Distances;
        protected Instance[] m_nnInstances;
        protected boolean m_SkipIdentical;
        protected boolean m_SkipDifferentClass;

        public LinearNNSearchENN() {
            this.m_SkipIdentical = false;
            this.m_SkipDifferentClass = false;
        }

        public LinearNNSearchENN(Instances insts) {
            super(insts);
            this.m_SkipIdentical = false;
            this.m_SkipDifferentClass = false;
            this.m_DistanceFunction.setInstances(insts);
        }

        public String globalInfo() {
            return "Class implementing the brute force search algorithm for nearest neighbour search.";
        }

        public Enumeration listOptions() {
            Vector<Option> result = new Vector<Option>();
            result.add(new Option("\tSkip identical instances (distances equal to zero).\n", "S", 1, "-S"));
            return result.elements();
        }

        public void setOptions(String[] options) throws Exception {
            super.setOptions(options);
            this.setSkipIdentical(Utils.getFlag((char)'S', (String[])options));
        }

        public String[] getOptions() {
            Vector<String> result = new Vector<String>();
            String[] options = super.getOptions();
            int i = 0;
            while (i < options.length) {
                result.add(options[i]);
                ++i;
            }
            if (this.getSkipIdentical()) {
                result.add("-S");
            }
            return result.toArray(new String[result.size()]);
        }

        public String skipIdenticalTipText() {
            return "Whether to skip identical instances (with distance 0 to the target)";
        }

        public void setSkipIdentical(boolean skip) {
            this.m_SkipIdentical = skip;
        }

        public boolean getSkipIdentical() {
            return this.m_SkipIdentical;
        }

        public String skipDifferentClassTipText() {
            return "Whether different instances are skipped ";
        }

        public void setSkipDifferentClass(boolean skip) {
            this.m_SkipDifferentClass = skip;
        }

        public boolean getSkipDifferentClass() {
            return this.m_SkipDifferentClass;
        }

        public Instance nearestNeighbour(Instance target) throws Exception {
            return this.kNearestNeighbours(target, 1).instance(0);
        }

        public Instances kNearestNeighbours(Instance target, int kNN) throws Exception {
            NearestNeighbourSearch.MyHeapElement h;
            boolean print = false;
            boolean bSkipDifferentClass = false;
            double tarjetClassValue = 0.0;
            if (this.m_Stats != null) {
                this.m_Stats.searchStart();
            }
            if (this.m_SkipDifferentClass) {
                try {
                    tarjetClassValue = target.classValue();
                    bSkipDifferentClass = true;
                }
                catch (UnassignedDatasetException ex) {
                    bSkipDifferentClass = false;
                }
            }
            NearestNeighbourSearch.MyHeap heap = new NearestNeighbourSearch.MyHeap((NearestNeighbourSearch)this, kNN);
            int firstkNN = 0;
            int i = 0;
            while (i < this.m_Instances.numInstances()) {
                block21: {
                    double distance;
                    block23: {
                        block24: {
                            block22: {
                                if (target == this.m_Instances.instance(i)) break block21;
                                if (!bSkipDifferentClass) break block22;
                                try {
                                    if (tarjetClassValue != this.m_Instances.instance(i).classValue()) {
                                    }
                                }
                                catch (UnassignedDatasetException ex) {}
                                break block21;
                            }
                            if (this.m_Stats != null) {
                                this.m_Stats.incrPointCount();
                            }
                            if (firstkNN >= kNN) break block23;
                            if (print) {
                                System.out.println("K(a): " + (heap.size() + heap.noOfKthNearest()));
                            }
                            if ((distance = this.m_DistanceFunction.distance(target, this.m_Instances.instance(i), Double.POSITIVE_INFINITY, this.m_Stats)) != 0.0 || !this.m_SkipIdentical) break block24;
                            if (i < this.m_Instances.numInstances() - 1) break block21;
                            heap.put(i, distance);
                        }
                        heap.put(i, distance);
                        ++firstkNN;
                        break block21;
                    }
                    NearestNeighbourSearch.MyHeapElement temp = heap.peek();
                    if (print) {
                        System.out.println("K(b): " + (heap.size() + heap.noOfKthNearest()));
                    }
                    if ((distance = this.m_DistanceFunction.distance(target, this.m_Instances.instance(i), temp.distance, this.m_Stats)) != 0.0 || !this.m_SkipIdentical) {
                        if (distance < temp.distance) {
                            heap.putBySubstitute(i, distance);
                        } else if (distance == temp.distance) {
                            heap.putKthNearest(i, distance);
                        }
                    }
                }
                ++i;
            }
            this.m_Distances = new double[heap.size() + heap.noOfKthNearest()];
            this.m_nnInstances = new Instance[heap.size() + heap.noOfKthNearest()];
            i = 1;
            while (heap.noOfKthNearest() > 0) {
                h = heap.getKthNearest();
                this.m_nnInstances[this.m_nnInstances.length - i] = this.m_Instances.instance(h.index);
                this.m_Distances[this.m_Distances.length - i] = h.distance;
                ++i;
            }
            while (heap.size() > 0) {
                h = heap.get();
                this.m_nnInstances[this.m_nnInstances.length - i] = this.m_Instances.instance(h.index);
                this.m_Distances[this.m_Distances.length - i] = h.distance;
                ++i;
            }
            this.m_DistanceFunction.postProcessDistances(this.m_Distances);
            Instances neighbours = new Instances(this.m_Instances, heap.size() + heap.noOfKthNearest());
            int k = 0;
            while (k < heap.size() + heap.noOfKthNearest()) {
                neighbours.add(this.m_nnInstances[k]);
                ++k;
            }
            if (this.m_Stats != null) {
                this.m_Stats.searchFinish();
            }
            return neighbours;
        }

        public double[] getDistances() throws Exception {
            if (this.m_Distances == null) {
                throw new Exception("No distances available. Please call either kNearestNeighbours or nearestNeighbours first.");
            }
            return this.m_Distances;
        }

        public Instance[] getNearestInstances() throws Exception {
            if (this.m_nnInstances == null) {
                throw new Exception("No indexes available. Please call either kNearestNeighbours or nearestNeighbours first.");
            }
            return this.m_nnInstances;
        }

        public void setInstances(Instances insts) throws Exception {
            this.m_Instances = insts;
            this.m_DistanceFunction.setInstances(insts);
        }

        public void update(Instance ins) throws Exception {
            if (this.m_Instances == null) {
                throw new Exception("No instances supplied yet. Cannot update withoutsupplying a set of instances first.");
            }
            this.m_DistanceFunction.update(ins);
        }

        public void addInstanceInfo(Instance ins) {
            if (this.m_Instances != null) {
                try {
                    this.update(ins);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        public String getRevision() {
            return null;
        }
    }
}

